#include "Main.h"

int trackTargetCheating(Game *g)
{
	int x,y, *tc, fails, val, direction, i, ret;
	assert (g != NULL);

	x = g->aiHitx;
	y = g->aiHity;
	assert (XYVALID(x,y));

	direction = -1;
	tc = &x;
	i = 0;
	fails = 0;
	while (1)
	{
		if (i < 5)
		{
			*tc += direction;
			if (!XYVALID(x,y)) {i++; continue;}
			val = mapGet(g->mapPlayer, x, y);
			if ((val & F_SHIP_PRESENT) && !(val & F_SHOT_FIRED))
			{
				ret = AI_Shoot(g->mapPlayer, x, y, g);
				printfCon(&(g->con), "What a lucky shot!\n");
				if (ret == 2)
				{
					g->aiState = 0;
					g->aiHity = g->aiHitx = -1;
				}
				return ret;
			}
		}
			if ((i >= 5) || !(val & F_SHIP_PRESENT))
			{
				switch (fails)
				{
				case 0: direction = -direction; break;
				case 1: tc = &y; break;
				case 2: direction = -direction; break;
				case 3:
					// If this happens then there's a bug. See the assert(0) line
					// in the trackTarget function for the full explanation
					assert(0);
					break;
				}
				fails++;
				x = g->aiHitx;
				y = g->aiHity;
				i = 0;
			}
			i++;
	}
}

int trackTarget(Game *g)
{
	int x,y, *tc, hcertainity, fails, val, direction, i, tx, ty, ret;
	assert (g != NULL);

	tx = g->aiHitx;
	ty = g->aiHity;
	assert (XYVALID(tx,ty));

	// tracking means we've managed to hit something,
	// and now we're trying to keep hitting it until
	// it's sunk.
	// At first we'll try to guess whether its
	// horizontal or vertical based on whether
	// there are other hits nearby.

	hcertainity = 0;
	tc = NULL;
	direction = 0;
	if (XYVALID(tx-1,ty))
	{
		val = mapGet(g->mapPlayer, tx-1, ty);
		if ((val & F_SHOT_FIRED) && (val & F_SHIP_PRESENT))
		{
			// certainly to the left
			tc = &x; direction = -1;
		}
	}
	if (XYVALID(tx+1,ty))
	{
		val = mapGet(g->mapPlayer, tx+1, ty);
		if ((val & F_SHOT_FIRED) && (val & F_SHIP_PRESENT))
		{
			// certainly to the right
			tc = &x; direction = 1;
		}
	}
	if (XYVALID(tx,ty-1))
	{
		val = mapGet(g->mapPlayer, tx, ty-1);
		if ((val & F_SHOT_FIRED) && (val & F_SHIP_PRESENT))
		{
			tc = &y; direction = -1;
		}
	}
	if (XYVALID(tx,ty+1))
	{
		val = mapGet(g->mapPlayer, tx, ty+1);
		if ((val & F_SHOT_FIRED) && (val & F_SHIP_PRESENT))
		{
			tc = &y; direction = 1;
		}
	}

	// if we couldn't make out anything then
	// resort to guessing
	if (tc == NULL)
	{
		if (rand()%100 < 50) tc = &x;
		else tc = &y;
	}
	if (direction == 0)
	{
		if (rand()%100 < 50) direction = 1;
		else direction = -1;
	}

	// do the actual shooting
	fails = 0;
	x = tx;
	y = ty;
	while (1)
	{
		for (i=1; i<=5; i++)
		{
			*tc += direction;
			if (!XYVALID(x,y) || 
				( (mapGet(g->mapPlayer, x, y) & F_SHOT_FIRED) &&
				!(mapGet(g->mapPlayer, x, y) & F_SHIP_PRESENT) ) )
			{
				if (fails == 0)
				{
					// we screwed up. note the mistake and reverse direction
					direction = -direction;
					fails = 1;
				}
				else if (fails == 1)
				{
					// we screwed up again. try changing the rotation
					if (tc == &x) tc = &y;
					else tc = &x;
					fails = 2;
				}
				else if (fails == 2)
				{
					// Third screw-up. There is only possible option remaining
					direction = -direction;
					fails = 3;
				}
				else if (fails == 3)
				{
					// So we went in every possible direction, but still couldn't
					// find a place to hit. This can only happen if there's a bug
					// in determining whether a ship was sunk or not. Or if the
					// tracking target wasn't cleared after sinking. Enjoy your
					// debugging.
					assert(0);
				}
				x = tx;
				y = ty;
				break;
			}
			else if ((mapGet(g->mapPlayer, x, y) & F_SHOT_FIRED)) // the ship was already hit here. Move along
				continue;

			ret = AI_Shoot(g->mapPlayer, x, y, g);
			if (ret == 2)
			{
				g->aiState = 0;
				g->aiHity = g->aiHitx = -1;
			}
			return ret;
		}
	}
}

int TrackingAILoop(Game *g, int useGrid, int useCheating)
{
	int x,y,val;
	int (*trackFunc)(Game*);
	
	assert (g != NULL);
	trackFunc = NULL;

	printMapWin(g, player, opponent);
	Sleep(500);

	if (g->aiState == 0)
	{
		if (!useCheating)
		{
			if (shootAtRandom(g, &x, &y, useGrid, 1) != 0)
			{
				g->aiState = 1;
				g->aiHitx = x;
				g->aiHity = y;
			}
		}
		else // cheating
		{
			while (1)
			{
				x = rand() % gameWidth;
				y = rand() % gameHeight;
				val = mapGet(g->mapPlayer, x, y);
				if (val & F_SHOT_FIRED) continue;
				if (val & F_SHIP_PRESENT) break;
			}
			AI_Shoot(g->mapPlayer, x, y, g);

			// we should notify the trakcing AI of our
			// unbelievably lucky shot. And the player too!
			printfCon(&(g->con), "What a lucky shot!\n");
			g->aiHitx = x;
			g->aiHity = y;
			g->aiState = 1;
		}
		if (g->opponentWon) return 0;
	}
	else
	{
		if (useCheating) trackFunc = trackTargetCheating;
		else trackFunc = trackTarget;
		if (trackFunc(g) == 2)
		{
			testDefeatCondition(g);
			if (g->opponentWon) return 0;
		}
	}
	printMapWin(g, player, opponent);
	return 1;
}

// a base function for tracking AIs
void TrackingAIBase (Game *g, int useGrid, int useCheating)
{
	int shotsLeft = shotsPerTurn;

	assert (g != NULL);

	while (shotsLeft > 0)
	{
		if (TrackingAILoop(g, useGrid, useCheating) == 0) break;
		shotsLeft--;
	}
}