#include "Main.h"

void MapCoordsToGrid(int x, int y, char *outbuf, int buflen)
{
	int *charvals, cvlen = 1, cvi = 0;

	assert(outbuf != NULL);
	assert(buflen > 0);
	assert(XYVALID(x,y));

	charvals = (int *)malloc(cvlen * sizeof(int));
	assert (charvals != NULL);
	while (x >= 26)
	{
		charvals[cvi++] = x % 26;
		if (cvi == cvlen)
		{
			cvlen *= 2;
			charvals = (int *)realloc(charvals, cvlen * sizeof(int));
			assert (charvals != NULL);
		}
		x = x / 26;
	}
	*(outbuf++) = 'A' + (x % 26);
	assert (buflen >= cvi+1);
	for (--cvi; cvi>=0; cvi--)
	{
		*(outbuf++) = 'A' + charvals[cvi];
	}
	free(charvals);

	sprintf(outbuf, "%d", y+1);

	//*outbuf = '\0';
}

int mapGet(unsigned char* map, int x, int y)
{
	assert (map != NULL);
	assert(XYVALID(x,y));
	return map[x + (y*gameWidth) ];
}

void mapSet(unsigned char* map, int x, int y, unsigned char value)
{
	if (map == NULL);
	assert(XYVALID(x,y));
	map[x + (y*gameWidth) ] = value;
}

void mapSetF(unsigned char* map, int x, int y, unsigned char flag)
{
	mapSet(map, x,y, ( mapGet(map,x,y) | flag ) );
}
void mapClearF(unsigned char* map, int x, int y, unsigned char flag)
{
	mapSet(map, x,y, ( mapGet(map,x,y) & ~flag ) );
}
int mapCheckF(unsigned char* map, int x, int y, unsigned char flag)
{
	return (mapGet(map,x,y) & flag);
}

void printMap (unsigned char* map, View v)
{
	int x,y;
	unsigned char val;
	if (map == NULL) return;
	printf("\n  |");
	for (x=0; x<gameWidth; x++) printf ("%c", 'A'+x);
	printf("\n--+");
	for (x=0; x<gameWidth; x++) printf ("%c", '-');
	for (y=0; y<gameHeight; y++)
	{
		printf ("\n%2d|", y+1);
		for (x=0; x<gameWidth; x++)
		{
			if (v == debug) printf ("%d", mapGet(map,x,y) );
			else if (v == player)
			{
				val = mapGet(map,x,y);
				if (val & F_SUNK) printf ("#");
				else if ((val & (F_SHIP_PRESENT | F_SHOT_FIRED)) == (F_SHIP_PRESENT | F_SHOT_FIRED) )
					printf ("X");
				else if (val & F_SHIP_PRESENT) printf ("O");
				else if (val & F_SHOT_FIRED) printf ("~");
				else printf (" ");
			}
			else // opponent
			{
				val = mapGet(map,x,y);
				if (val & F_SUNK) printf ("#");
				else if ((val & (F_SHIP_PRESENT | F_SHOT_FIRED)) == (F_SHIP_PRESENT | F_SHOT_FIRED) )
					printf ("X");
				else if (val & F_SHOT_FIRED) printf ("~");
				else printf (" ");
			}
		}
	}
	printf ("\n");
}


int areThereAnyShipsSurviving(unsigned char *map)
{
	int i;
	unsigned char val;
	assert(map != NULL);
	
	for (i=0; i<gameWidth * gameHeight; i++)
	{
		val = map[i];
		if (val & F_SHIP_PRESENT)
		{
			if ((val & F_SUNK) == 0) return 1;
		}
	}
	return 0;
}

// returns 0 if miss, 1 if hit, 2 if sunk, and -1 if
// the target was hit already
int Shoot(unsigned char* map, int x, int y, WinConsole *con)
{
	unsigned char val;
	int sx,sy, *tc, *oc, is_sunk;

	assert(map != NULL);
	assert(XYVALID(x,y));

	val = mapGet(map, x,y);
	if (val & F_SHOT_FIRED) return -1;
	val = val | F_SHOT_FIRED;
	mapSet(map, x, y, val);

	// Set up the neghbouring fields with information
	// that this field was shot. The expert AI uses this
	// for its grid strategy.
	for (sx = -1; sx <= +1; sx++)
	{
		for (sy = -1; sy <= +1; sy++)
		{
			if (!XYVALID(x+sx,y+sy)) continue;
			if (sx == sy || sx == -sy) continue; // cut corners
			mapSetF(map, x+sx, y+sy, F_NEIGHBOR_SHOT);
		}
	}

	// If there's a ship in here then we have to find out whether it
	// was sunk or not. This not the best way of doing it, it would be
	// better to just remember the ship positions and sizes from
	// placement.
	// TODO: rewrite this
	if (val & F_SHIP_PRESENT)
	{
		is_sunk = 1;
		while (XVALID(x-1) && mapCheckF(map,x-1,y, F_SHIP_PRESENT)) x--;
		while (YVALID(y-1) && mapCheckF(map,x,y-1, F_SHIP_PRESENT)) y--;
		sx = x;
		sy = y;
		if (!XVALID(x+1) || !mapCheckF(map,x+1,y, F_SHIP_PRESENT))
		{
				tc = &y;
				oc = &x;
		}
		else
		{
				tc = &x;
				oc = &y;
		}
		while (XYVALID(x,y) && mapCheckF(map,x,y, F_SHIP_PRESENT))
		{
			if (!mapCheckF(map,x,y, F_SHOT_FIRED))
			{
				is_sunk = 0;
				break;
			}
			(*tc)++;
		}
		if (is_sunk)
		{
			x = sx;
			y = sy;

			// three squares before the ship
			(*tc)--;
			(*oc)--;
			if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
			(*oc)+=2;
			if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
			(*oc)--;
			if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
			(*tc)++;

			while (XYVALID(x,y) && mapCheckF(map,x,y, F_SHIP_PRESENT))
			{
				mapSetF(map,x,y, F_SUNK);

				(*oc)--;
				if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
				(*oc)+=2;
				if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
				(*oc)--;

				(*tc)++;
			}

			// three squares after the ship
			(*oc)--;
			if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
			(*oc)+=2;
			if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);
			(*oc)--;
			if (XYVALID(x,y)) mapSetF(map,x,y, F_SHOT_FIRED);

			printfCon (con, "Hit & Sunk!\n");
			return 2;
		}
		else {printfCon (con, "Hit!\n"); return 1;}
	}
	else {is_sunk = 0; printfCon (con, "Miss!\n"); return 0; }

	if (is_sunk) return 2;
	else return 0;
}